class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'The Telegraph'
    oldest_article = 7
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    
    remove_tags_before = dict(id='tmglBody')
    remove_attributes = ['style', 'font']
    remove_tags = [dict(name='div', attrs={'class':['oneSixth','top','column1','oneThird','byline','access','related_links_inline','storyFt','printHide','backtotop','gutterUnder','embeddedFirstVideo']}),
                   dict(name='div', attrs={'id':['storyEmbSlide','tmglFooterLarge','tmglHotTopics','diggPermaUrl','moreOnCarousel']}),
                   dict(name='img'),]

    feeds          = [
                        (u'World News', u'http://www.telegraph.co.uk/news/worldnews/rss'),
                        (u'UK News', u'http://www.telegraph.co.uk/news/uknews/rss'),
                        (u'Columnists', u'http://www.telegraph.co.uk/comment/columnists/rss'),
                        (u'Technology News', u'http://www.telegraph.co.uk/technology/news/rss'),
                        (u'Rock n Pop News', u'http://www.telegraph.co.uk/culture/music/rockandpopmusic/rss'),
                        (u'DVD Reviews', u'http://www.telegraph.co.uk/culture/film/dvd-reviews/rss'),
                        (u'Science News', u'http://www.telegraph.co.uk/science/science-news/rss'),
                        (u'Football', u'http://www.telegraph.co.uk/sport/football/rss'),
                        (u'Earth News', u'http://www.telegraph.co.uk/earth/earthnews/rss'),
                        (u'Comment', u'http://www.telegraph.co.uk/comment/rss'),
                        (u'How about that?', u'http://www.telegraph.co.uk/news/newstopics/howaboutthat/rss')
                     ]				  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup

    def parse_feeds (self): 
      feeds = BasicNewsRecipe.parse_feeds(self) 
      for feed in feeds:
        for article in feed.articles[:]:
          print 'article.title is: ', article.title
          if 'VIDEO' in article.title.upper() or 'galleries' in article.url:
            feed.articles.remove(article)
      return feeds